#include "ExprArray.h"

#include "ExpressionDict.h"
#include "ArgList.h"
#include "Expression.h"


ExprArray::ExprArray() {
	mExprs = NULL;
	mNumExprs = 0;
}




ExprArray::~ExprArray() {

	if ( mExprs )
		delete []mExprs;
}






void ExprArray::Compile( const ArgList& inArgs, long inID, ExpressionDict& ioDict ) {
	UtilStr str, IDStr;
	unsigned long i;
	
	mNumExprs = inArgs.GetArraySize( inID );
	
	if ( mExprs )
		delete []mExprs;
		
	mExprs = new Expression[ mNumExprs + 1 ];
	
	i = inID;
	while ( i > 0 ) {
		IDStr.Prepend( (char) ( i & 0xFF ) );
		i = i >> 8;
	}
	
	for ( i = 0; i < mNumExprs; i++ ) {
		str.Assign( IDStr );
		str.Append( (long) i );
		mVals[ i ] = 0;
		ioDict.AddVar( str, &mVals[ i ] );
		inArgs.GetArg( inID, str, i );
		mExprs[ i ].Compile( str, ioDict );
	}
}


void ExprArray::Evaluate() {
	int i;
	
	for ( i = 0; i < mNumExprs; i++ )
		mVals[ i ] = mExprs[ i ].Evaluate();
}


